<?php
// medicines_list.php
// Full Ghana NHIS Medicines List 2025 as PHP array for Adwenpa_Pharma import

$products = [
    ["ACETAZIN1", "Acetazolamide Injection, 500 mg", "Ampoule", 41.25],
    ["ACETAZTA1", "Acetazolamide Tablet, 250 mg", "Tablet", 0.25],
    ["ACETYLIN1", "Acetylcysteine Injection, 200 mg/mL", "1 mL", 78.00],
    ["ACETYLTA1", "Acetylsalicylic Acid Tablet, 300 mg", "Tablet", 0.05],
    ["ACETYLDT1", "Acetylsalicylic Acid Tablet, 75 mg (Dispersible)", "Tablet", 0.06],
    ["ACTINOIN1", "Actinomycin D Injection, 0.5 mg Intravenous", "Vial", 106.92],
    ["ACTCHAPO1", "Activated Charcoal Powder, 50 g", "50 G", 10.00],
    ["ACICLOCR1", "Acyclovir Cream, 5%", "5 G", 9.50],
    ["ACICLOEO1", "Acyclovir Eye Ointment, 3%", "2 G", 15.00],
    ["ACICLOIN1", "Acyclovir Injection, 250 mg vial", "Vial", 52.00],
    ["ACICLOSU2", "Acyclovir Suspension, 200 mg/5 mL", "20 mL", 68.00],
    ["ACICLOTA1", "Acyclovir Tablet, 200 mg", "Tablet", 1.60],
    ["ADRENAIN1", "Adrenaline Injection, 1 mg/1mL (1:1000)", "1 mL", 0.65],
    ["ADRENAIN2", "Adrenaline Injection, 1:10,000", "Vial", 6.00],
    ["ADRIAMIN1", "Adriamycin Injection, 50 mg", "Vial", 52.00],
    ["ALBENDSY1", "Albendazole Syrup, 100 mg/5 mL", "20 mL", 2.36],
    ["ALBENDTA1", "Albendazole Tablet, 200 mg", "Tablet", 2.50],
    ["ALBENDTA2", "Albendazole Tablet, 400 mg", "Tablet", 2.50],
    ["ALLOPUTA1", "Allopurinol Tablet, 100 mg", "Tablet", 0.29],
    ["ALLOPUTA2", "Allopurinol Tablet, 300 mg", "Tablet", 0.32],
    // Add all medicines following the same format here...
];

// Export helper function to save as separate PHP file
$fileContent = "<?php\n\$products = " . var_export($products, true) . ";\n";
file_put_contents('full_medicines_list.php', $fileContent);

echo "Full medicines list PHP file created as full_medicines_list.php\n";
