<?php
// includes/role_helpers.php

// Check if user is logged in
function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

// Check if user is admin
function isAdmin() {
    return isset($_SESSION['role']) && $_SESSION['role'] === 'admin';
}

// Check if user is sales rep
function isSalesRep() {
    return isset($_SESSION['role']) && $_SESSION['role'] === 'sales_rep';
}

// Enforce login: redirect to login page if not logged in
function requireLogin() {
    if (!isLoggedIn()) {
        header('Location: login.php');
        exit;
    }
}

// Enforce admin role; redirect if not admin
function requireAdmin() {
    requireLogin();
    if (!isAdmin()) {
        header('Location: dashboard.php');
        exit;
    }
}

// Enforce sales rep role; redirect if not sales rep
function requireSalesRep() {
    requireLogin();
    if (!isSalesRep()) {
        header('Location: dashboard.php');
        exit;
    }
}

// Generic role check: does current user have one of allowed roles?
function userHasRole(array $allowedRoles) {
    if (!isLoggedIn()) return false;
    return in_array($_SESSION['role'], $allowedRoles);
}
?>
