<?php
require_once "../config/config.php";
require_once "../includes/auth_check.php";
requireAdmin();

$conn = getDbConnection();

$username = $full_name = $email = $role = $password = "";
$username_err = $email_err = $password_err = $branch_err = "";

// Fetch branches for dropdown
$branch_result = $conn->query("SELECT branch_id, branch_name FROM branches ORDER BY branch_name");
$branches = [];
if ($branch_result) {
    $branches = $branch_result->fetch_all(MYSQLI_ASSOC);
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $username = trim($_POST["username"]);
    $full_name = trim($_POST["full_name"]);
    $email = trim($_POST["email"]);
    $role = $_POST["role"];
    $password = trim($_POST["password"]);
    $branch_id = $_POST["branch_id"] ?? "";

    // Basic validations
    if (empty($username)) { $username_err = "Username is required."; }
    if (empty($email)) { $email_err = "Email is required."; }
    if (empty($password) || strlen($password) < 6) { $password_err = "Password must be at least 6 characters."; }
    if (empty($branch_id)) { $branch_err = "Branch is required."; }

    if (empty($username_err) && empty($email_err) && empty($password_err) && empty($branch_err)) {
        // Check if username or email exists
        $stmt = $conn->prepare("SELECT user_id FROM users WHERE username = ? OR email = ?");
        $stmt->bind_param("ss", $username, $email);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows > 0) {
            $username_err = "Username or Email already taken.";
            $stmt->close();
        } else {
            $stmt->close();
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);

            $insert = $conn->prepare("INSERT INTO users (username, full_name, email, password_hash, role, branch_id) VALUES (?, ?, ?, ?, ?, ?)");
            $insert->bind_param("sssssi", $username, $full_name, $email, $hashed_password, $role, $branch_id);
            $insert->execute();

            if ($insert->affected_rows === 1) {
                header("Location: manage_users.php?success=User added successfully");
                exit();
            } else {
                echo "Error adding user.";
            }
            $insert->close();
        }
    }
}
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Add New User</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <style>
        body {
            background: #f8f9fa;
        }
        .user-form-card {
            max-width: 520px;
            margin: 48px auto;
        }
    </style>
</head>
<body>
<div class="user-form-card card shadow-sm p-4">
    <h2 class="mb-4">Add New User</h2>
    <form method="post" novalidate>
        <div class="mb-3">
            <label for="username" class="form-label">Username *</label>
            <input type="text" class="form-control <?= $username_err ? 'is-invalid' : '' ?>" id="username" name="username" value="<?= htmlspecialchars($username) ?>" required />
            <?php if ($username_err): ?>
                <div class="invalid-feedback"><?= htmlspecialchars($username_err) ?></div>
            <?php endif; ?>
        </div>
        <div class="mb-3">
            <label for="full_name" class="form-label">Full Name *</label>
            <input type="text" class="form-control" id="full_name" name="full_name" value="<?= htmlspecialchars($full_name) ?>" required />
        </div>
        <div class="mb-3">
            <label for="email" class="form-label">Email *</label>
            <input type="email" class="form-control <?= $email_err ? 'is-invalid' : '' ?>" id="email" name="email" value="<?= htmlspecialchars($email) ?>" required />
            <?php if ($email_err): ?>
                <div class="invalid-feedback"><?= htmlspecialchars($email_err) ?></div>
            <?php endif; ?>
        </div>
        <div class="mb-3">
            <label for="role" class="form-label">Role *</label>
            <select class="form-select" id="role" name="role" required>
                <option value="">Select role</option>
                <option value="admin" <?= $role === "admin" ? "selected" : "" ?>>Admin</option>
                <option value="staff" <?= $role === "staff" ? "selected" : "" ?>>Staff</option>
                <option value="customer" <?= $role === "customer" ? "selected" : "" ?>>Customer</option>
            </select>
        </div>

        <div class="mb-3">
            <label for="branch_id" class="form-label">Branch *</label>
            <select class="form-select <?= $branch_err ? 'is-invalid' : '' ?>" id="branch_id" name="branch_id" required>
                <option value="">Select branch</option>
                <?php foreach ($branches as $branch): ?>
                    <option value="<?= $branch['branch_id'] ?>" <?= (isset($_POST["branch_id"]) && $_POST["branch_id"] == $branch['branch_id']) ? "selected" : "" ?>>
                        <?= htmlspecialchars($branch['branch_name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <?php if ($branch_err): ?>
                <div class="invalid-feedback"><?= htmlspecialchars($branch_err) ?></div>
            <?php endif; ?>
        </div>

        <div class="mb-3">
            <label for="password" class="form-label">Password *</label>
            <input type="password" class="form-control <?= $password_err ? 'is-invalid' : '' ?>" id="password" name="password" required />
            <?php if ($password_err): ?>
                <div class="invalid-feedback"><?= htmlspecialchars($password_err) ?></div>
            <?php endif; ?>
        </div>
        <div class="mt-4">
            <button type="submit" class="btn btn-primary">Add User</button>
            <a href="manage_users.php" class="btn btn-secondary ms-2">Cancel</a>
        </div>
    </form>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
