<?php
require_once "../config/config.php";
session_start();
require_once "../includes/role_helpers.php";
requireAdmin();

$dbHost = 'localhost';
$dbUser = 'root';
$dbPass = '';
$dbName = 'adwenpa_pharma';

$backupFolder = __DIR__ . '/backups/';
if (!is_dir($backupFolder)) {
    mkdir($backupFolder, 0755, true);
}

$message = '';

// Set full path to mysqldump.exe with double backslashes and quotes for Windows
$mysqldumpPath = '"C:\\xampp\\mysql\\bin\\mysqldump.exe"';

// Handle backup creation
if (isset($_POST['backup_now'])) {
    $backupFile = $backupFolder . $dbName . '_' . date('Ymd_His') . '.sql';

    // Escape shell arguments for safety
    $command = $mysqldumpPath
        . ' --user=' . escapeshellarg($dbUser)
        . ' --password=' . escapeshellarg($dbPass)
        . ' --host=' . escapeshellarg($dbHost)
        . ' ' . escapeshellarg($dbName)
        . ' > ' . escapeshellarg($backupFile)
        . ' 2>&1';

    exec($command, $output, $return_var);

    if ($return_var === 0) {
        $message = "Backup successful: " . basename($backupFile);
    } else {
        $message = "Backup failed. Error output:\n" . implode("\n", $output);
    }
}

// Handle backup deletion
if (isset($_POST['delete_backup']) && !empty($_POST['filename'])) {
    $fileToDelete = basename($_POST['filename']);
    $fullPath = $backupFolder . $fileToDelete;
    if (is_file($fullPath)) {
        if (unlink($fullPath)) {
            $message = "Backup deleted: " . htmlspecialchars($fileToDelete);
        } else {
            $message = "Failed to delete backup: " . htmlspecialchars($fileToDelete);
        }
    } else {
        $message = "File not found: " . htmlspecialchars($fileToDelete);
    }
}

// List backups sorted newest first
$backups = array_diff(scandir($backupFolder, SCANDIR_SORT_DESCENDING), ['.', '..']);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Database Backup - Adwenpa Pharma</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <style>
        pre {
            white-space: pre-wrap;
            word-break: break-word;
        }
    </style>
</head>
<body>
<div class="container my-4">
    <h2>Database Backup</h2>

    <?php if ($message): ?>
        <div class="alert <?= stripos($message, 'failed') !== false ? 'alert-danger' : 'alert-success' ?>">
            <pre><?= htmlspecialchars($message) ?></pre>
        </div>
    <?php endif; ?>

    <form method="post" class="mb-3">
        <button type="submit" name="backup_now" class="btn btn-primary">Create Backup Now</button>
        <a href="dashboard.php" class="btn btn-secondary ms-2">Back to Dashboard</a>
    </form>

    <h4>Existing Backups</h4>
    <?php if (empty($backups)): ?>
        <p>No backups available.</p>
    <?php else: ?>
        <ul class="list-group">
            <?php foreach ($backups as $file): ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <?= htmlspecialchars($file) ?>
                    <div>
                        <a href="backups/<?= rawurlencode($file) ?>" class="btn btn-sm btn-outline-primary" download>Download</a>
                        <form method="post" style="display:inline;" onsubmit="return confirm('Are you sure you want to delete this backup?');">
                            <input type="hidden" name="filename" value="<?= htmlspecialchars($file) ?>" />
                            <button type="submit" name="delete_backup" class="btn btn-sm btn-outline-danger ms-2">Delete</button>
                        </form>
                    </div>
                </li>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
