<?php
session_start();

// Redirect logged-in users to their dashboard
if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true) {
    header('Location: dashboard.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Welcome to Adwenpa Pharma</title>
    <link rel="stylesheet" href="css/bootstrap.min.css" />
    <style>
        body, html {
            height: 100%;
            margin: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #4A90E2, #50E3C2);
            color: #fff;
            text-align: center;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            overflow-x: hidden;
        }
        .container {
            background: rgba(0, 0, 0, 0.5);
            padding: 40px;
            border-radius: 10px;
            width: 100%;
            max-width: 450px;
            box-shadow: 0 8px 24px rgba(0,0,0,0.4);
            z-index: 10;
        }
        h1 {
            font-weight: 700;
            margin-bottom: 20px;
            text-shadow: 1px 1px 4px rgba(0,0,0,0.6);
        }
        p {
            font-size: 1.1rem;
            margin-bottom: 30px;
            text-shadow: 1px 1px 4px rgba(0,0,0,0.4);
        }
        .btn-primary {
            padding: 10px 30px;
            font-size: 1.1rem;
            border-radius: 50px;
            transition: background-color 0.3s ease;
            box-shadow: 2px 2px 6px rgba(0,0,0,0.3);
        }
        .btn-primary:hover {
            background-color: #3778c2;
            color: #fff;
        }
        body::before, body::after {
            content: '';
            position: fixed;
            opacity: 0.1;
            pointer-events: none;
            background-repeat: no-repeat;
            background-size: contain;
            z-index: 1;
        }
        body::before {
            background-image: url('/assets/drug1.png');
            top: 10%;
            left: 5%;
            width: 200px;
            height: 200px;
            transform: rotate(-15deg);
        }
        body::after {
            background-image: url('/assets/tablet1.png');
            bottom: 15%;
            right: 5%;
            width: 180px;
            height: 180px;
            transform: rotate(10deg);
        }
        @media (max-width: 600px) {
            body::before, body::after {
                display: none;
            }
        }
        footer.footer {
            width: 100%;
            padding: 10px 0;
            background: rgba(0, 0, 0, 0.3);
            color: #ddd;
            position: fixed;
            bottom: 0;
            left: 0;
            text-align: center;
            font-size: 0.9rem;
            user-select: none;
            z-index: 20;
        }
    </style>
</head>
<body>

<div class="container">
    <h1>Welcome to Adwenpa Pharma</h1>
    <p>Your trusted pharmacy point-of-sale and management solution</p>
    <a href="login.php" class="btn btn-primary btn-block mb-4">Login</a>
</div>

<footer class="footer">
    Developed by Adwenpa Consults. +233543971188
</footer>

</body>
</html>
