<?php
require_once "../config/config.php";
session_start();
require_once "../includes/role_helpers.php";
requireLogin();

$conn = getDbConnection();

$page = max(1, intval($_GET['page'] ?? 1));
$per_page = 15;
$offset = ($page - 1) * $per_page;

// Handle deletion request
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_id'])) {
    $delete_id = intval($_POST['delete_id']);
    $stmt = $conn->prepare("DELETE FROM prescriptions WHERE prescription_id = ?");
    $stmt->bind_param("i", $delete_id);
    $stmt->execute();
    $stmt->close();
    header("Location: manage_prescriptions.php?page=$page");
    exit;
}

// Total prescriptions count for pagination
$total_result = $conn->query("SELECT COUNT(*) AS total FROM prescriptions");
$total_prescriptions = $total_result->fetch_assoc()['total'] ?? 0;
$total_pages = ceil($total_prescriptions / $per_page);

// Fetch prescriptions with user info (sales rep)
$sql = "
SELECT p.prescription_id, p.prescription_date, p.patient_name, u.username
FROM prescriptions p
JOIN users u ON p.sales_rep_id = u.user_id
ORDER BY p.prescription_date DESC
LIMIT ?, ?
";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ii", $offset, $per_page);
$stmt->execute();
$result = $stmt->get_result();

$username = $_SESSION["username"];
$role = $_SESSION["role"];

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Manage Prescriptions - Adwenpa Pharma</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
    <div class="container-fluid">
        <a class="navbar-brand" href="dashboard.php">Adwenpa Pharma</a>
        <div class="d-flex">
            <span class="navbar-text me-3 text-white">Logged in as <?= htmlspecialchars($username) ?></span>
            <a href="logout.php" class="btn btn-outline-light btn-sm">Logout</a>
        </div>
    </div>
</nav>

<div class="container my-4">
    <h2>Manage Prescriptions</h2>
    <a href="dashboard.php" class="btn btn-secondary mb-3">&larr; Back to Dashboard</a>
    <a href="prescription_form.php" class="btn btn-success mb-3 ms-2">Add Prescription</a>

    <?php if ($result->num_rows === 0): ?>
        <div class="alert alert-info">No prescriptions found.</div>
    <?php else: ?>
        <table class="table table-bordered table-striped align-middle">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>Patient Name</th>
                    <th>Prescribed By</th>
                    <th>Prescription Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $count = $offset + 1; ?>
                <?php while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?= $count++ ?></td>
                        <td><?= htmlspecialchars($row['patient_name']) ?></td>
                        <td><?= htmlspecialchars($row['username']) ?></td>
                        <td><?= htmlspecialchars($row['prescription_date']) ?></td>
                        <td>
                            <a href="view_prescription.php?id=<?= $row['prescription_id'] ?>" class="btn btn-primary btn-sm">View</a>
                            <a href="prescription_form.php?id=<?= $row['prescription_id'] ?>" class="btn btn-warning btn-sm">Edit</a>
                            <form method="post" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this prescription?');">
                                <input type="hidden" name="delete_id" value="<?= $row['prescription_id'] ?>" />
                                <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                            </form>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>

        <!-- Pagination -->
        <nav aria-label="Page navigation">
            <ul class="pagination justify-content-center">
                <?php if ($page > 1): ?>
                    <li class="page-item"><a class="page-link" href="?page=<?= $page-1 ?>">Previous</a></li>
                <?php else: ?>
                    <li class="page-item disabled"><span class="page-link">Previous</span></li>
                <?php endif; ?>

                <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                    <li class="page-item<?= $i === $page ? ' active' : '' ?>">
                        <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                    </li>
                <?php endfor; ?>

                <?php if ($page < $total_pages): ?>
                    <li class="page-item"><a class="page-link" href="?page=<?= $page+1 ?>">Next</a></li>
                <?php else: ?>
                    <li class="page-item disabled"><span class="page-link">Next</span></li>
                <?php endif; ?>
            </ul>
        </nav>
    <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
