<?php
session_start();
require_once "../config/config.php";

// Expect an alert ID via POST
$alert_id = intval($_POST['alert_id'] ?? 0);
if ($alert_id <= 0) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid alert ID']);
    exit;
}

$conn = getDbConnection();

$stmt = $conn->prepare("UPDATE stock_alerts SET is_read = TRUE WHERE alert_id = ?");
$stmt->bind_param("i", $alert_id);
if ($stmt->execute()) {
    echo json_encode(['success' => true]);
} else {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to update alert']);
}
$stmt->close();
$conn->close();
