<?php
require_once "../config/config.php";
session_start();
require_once "../includes/role_helpers.php";
requireLogin();

$sale_id = isset($_GET['sale_id']) ? intval($_GET['sale_id']) : 0;
if ($sale_id <= 0) {
    header("Location: pos.php");
    exit;
}

$conn = getDbConnection();
$stmt = $conn->prepare("SELECT sale_date, total_amount FROM sales WHERE sale_id = ?");
$stmt->bind_param("i", $sale_id);
$stmt->execute();
$stmt->bind_result($sale_date, $total_amount);

if (!$stmt->fetch()) {
    $stmt->close();
    $conn->close();
    die("Sale record not found.");
}
$stmt->close();
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Sale Successful - Adwenpa Pharma</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <style>
        body { padding: 2rem; background: #f8f9fa; }
        .success-box { max-width: 420px; margin: 4rem auto; background: white; padding: 2rem; border-radius: 12px; box-shadow: 0 4px 20px rgb(13 110 253 / 0.1); text-align: center; }
    </style>
</head>
<body>
    <div class="success-box">
        <h1 class="text-success mb-3"><i class="bi bi-check-circle-fill"></i> Sale Successful</h1>
        <p><strong>Sale ID:</strong> <?= htmlspecialchars($sale_id) ?></p>
        <p><strong>Date:</strong> <?= htmlspecialchars($sale_date) ?></p>
        <p><strong>Total Amount:</strong> ₵<?= number_format($total_amount, 2) ?></p>
        <a href="pos.php" class="btn btn-primary mt-3 me-2">New Sale</a>
        <a href="view_sale.php?sale_id=<?= $sale_id ?>" class="btn btn-secondary mt-3">View Sale Details</a>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.13.0/font/bootstrap-icons.min.css" rel="stylesheet" />
</body>
</html>
