<?php
session_start();
require_once "../includes/role_helpers.php";
requireAdmin();
require_once "../config/config.php";

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("Location: dashboard.php");
    exit;
}

$conn = getDbConnection();

$product_name = trim($_POST['product_name'] ?? '');
$barcode = trim($_POST['barcode'] ?? '');
$category = trim($_POST['category'] ?? '');
$price = floatval($_POST['price'] ?? 0);
$stock_quantity = intval($_POST['stock_quantity'] ?? 0);
$expiry_date = $_POST['expiry_date'] ?? null;
$batch_number = trim($_POST['batch_number'] ?? '');
$branch_id = intval($_POST['branch_id'] ?? 0);

$errors = [];

if ($product_name === '') {
    $errors[] = "Product name is required.";
}

if ($price <= 0) {
    $errors[] = "Price must be a positive value.";
}

if ($stock_quantity < 0) {
    $errors[] = "Stock quantity cannot be negative.";
}

if ($branch_id <= 0) {
    $errors[] = "Valid branch must be selected.";
}

if ($expiry_date !== null && $expiry_date !== '') {
    $date_obj = DateTime::createFromFormat('Y-m-d', $expiry_date);
    if (!$date_obj || $date_obj->format('Y-m-d') !== $expiry_date) {
        $errors[] = "Expiry date is invalid.";
    }
} else {
    $expiry_date = null; // Set null if empty
}

if (count($errors) > 0) {
    $_SESSION['product_add_errors'] = $errors;
    header("Location: dashboard.php");
    exit;
}

try {
    $stmt = $conn->prepare("INSERT INTO products (product_name, barcode, category, price, stock_quantity, expiry_date, batch_number, branch_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    if (!$stmt) {
        throw new Exception("Prepare failed: " . $conn->error);
    }
    $stmt->bind_param("sssdisii", $product_name, $barcode, $category, $price, $stock_quantity, $expiry_date, $batch_number, $branch_id);
    $stmt->execute();
    if ($stmt->affected_rows <= 0) {
        throw new Exception("Insert failed. No rows affected.");
    }
    $stmt->close();

    $_SESSION['product_add_success'] = "Product added successfully.";
    header("Location: dashboard.php");
    exit;
} catch (Exception $ex) {
    $_SESSION['product_add_errors'] = [$ex->getMessage()];
    header("Location: dashboard.php");
    exit;
}
