<?php
session_start();
require_once __DIR__ . '/../config/config.php';

if (!isset($_GET['branch_id'])) {
    header("Location: index.php");
    exit;
}

$branch_id = intval($_GET['branch_id']);

$conn = getDbConnection();
$stmt = $conn->prepare("SELECT branch_id FROM branches WHERE branch_id = ?");
$stmt->bind_param("i", $branch_id);
$stmt->execute();
$stmt->store_result();

if ($stmt->num_rows === 1) {
    $_SESSION['branch_id'] = $branch_id;
    $stmt->close();
    $conn->close();

    header("Location: login.php"); // or dashboard.php if appropriate
    exit;
} else {
    $stmt->close();
    $conn->close();

    // Invalid branch selected, redirect back with error or show message
    header("Location: index.php?error=invalid_branch");
    exit;
}
?>
