<?php
require_once "../config/config.php";
session_start();
require_once "../includes/role_helpers.php";
requireAdmin();
$conn = getDbConnection();

$action = $_GET['action'] ?? '';
$supplier_id = intval($_GET['id'] ?? 0);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $contact_name = trim($_POST['contact_name']);
    $phone = trim($_POST['phone']);
    $email = trim($_POST['email']);
    $address = trim($_POST['address']);
    $payment_terms = trim($_POST['payment_terms']);

    if ($action === 'edit' && $supplier_id > 0) {
        $stmt = $conn->prepare("UPDATE suppliers SET name=?, contact_name=?, phone=?, email=?, address=?, payment_terms=? WHERE supplier_id=?");
        $stmt->bind_param("ssssssi", $name, $contact_name, $phone, $email, $address, $payment_terms, $supplier_id);
        $stmt->execute();
        $stmt->close();
    } else {
        $stmt = $conn->prepare("INSERT INTO suppliers (name, contact_name, phone, email, address, payment_terms) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("ssssss", $name, $contact_name, $phone, $email, $address, $payment_terms);
        $stmt->execute();
        $stmt->close();
    }
    header("Location: suppliers.php");
    exit;
}

if ($action === 'delete' && $supplier_id > 0) {
    $stmt = $conn->prepare("DELETE FROM suppliers WHERE supplier_id=?");
    $stmt->bind_param("i", $supplier_id);
    $stmt->execute();
    $stmt->close();
    header("Location: suppliers.php");
    exit;
}

$suppliers = $conn->query("SELECT * FROM suppliers ORDER BY name ASC");
$supplier = null;
if ($action === 'edit' && $supplier_id > 0) {
    $result = $conn->query("SELECT * FROM suppliers WHERE supplier_id = $supplier_id");
    $supplier = $result->fetch_assoc();
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Supplier Management - Adwenpa Pharma</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>
<div class="container my-4">
    <h2><?= $action === 'edit' ? "Edit Supplier" : "Add Supplier" ?></h2>

    <form method="post" class="mb-4" novalidate>
        <div class="mb-3">
            <label for="name" class="form-label">Supplier Name</label>
            <input type="text" name="name" id="name" required class="form-control" value="<?= htmlspecialchars($supplier['name'] ?? '') ?>" />
        </div>
        <div class="mb-3">
            <label for="contact_name" class="form-label">Contact Name</label>
            <input type="text" name="contact_name" id="contact_name" class="form-control" value="<?= htmlspecialchars($supplier['contact_name'] ?? '') ?>" />
        </div>
        <div class="mb-3">
            <label for="phone" class="form-label">Phone</label>
            <input type="text" name="phone" id="phone" class="form-control" value="<?= htmlspecialchars($supplier['phone'] ?? '') ?>" />
        </div>
        <div class="mb-3">
            <label for="email" class="form-label">Email</label>
            <input type="email" name="email" id="email" class="form-control" value="<?= htmlspecialchars($supplier['email'] ?? '') ?>" />
        </div>
        <div class="mb-3">
            <label for="address" class="form-label">Address</label>
            <textarea name="address" id="address" class="form-control"><?= htmlspecialchars($supplier['address'] ?? '') ?></textarea>
        </div>
        <div class="mb-3">
            <label for="payment_terms" class="form-label">Payment Terms</label>
            <input type="text" name="payment_terms" id="payment_terms" class="form-control" value="<?= htmlspecialchars($supplier['payment_terms'] ?? '') ?>" />
        </div>
        <button type="submit" class="btn btn-primary"><?= $action === 'edit' ? "Update" : "Add" ?></button>
        <?php if ($action === 'edit'): ?>
            <a href="suppliers.php" class="btn btn-secondary">Cancel</a>
        <?php endif; ?>
    </form>
    
    <a href="dashboard.php" class="btn btn-outline-secondary mb-4"><i class="bi bi-arrow-left"></i> Back to Dashboard</a>

    <h3>Suppliers List</h3>
    <table class="table table-striped">
        <thead>
            <tr><th>Name</th><th>Contact</th><th>Phone</th><th>Email</th><th>Payment Terms</th><th>Actions</th></tr>
        </thead>
        <tbody>
            <?php while($row = $suppliers->fetch_assoc()): ?>
                <tr>
                    <td><?= htmlspecialchars($row['name']) ?></td>
                    <td><?= htmlspecialchars($row['contact_name']) ?></td>
                    <td><?= htmlspecialchars($row['phone']) ?></td>
                    <td><?= htmlspecialchars($row['email']) ?></td>
                    <td><?= htmlspecialchars($row['payment_terms']) ?></td>
                    <td>
                        <a href="suppliers.php?action=edit&id=<?= $row['supplier_id'] ?>" class="btn btn-sm btn-info">Edit</a>
                        <a href="suppliers.php?action=delete&id=<?= $row['supplier_id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this supplier?');">Delete</a>
                    </td>
                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<!-- Add Bootstrap icons -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.13.0/font/bootstrap-icons.min.css" rel="stylesheet" />
</body>
</html>
