<?php
session_start();
require_once "../includes/role_helpers.php";
requireAdmin();
require_once "../config/config.php";

$conn = getDbConnection();

$success_msg = $error_msg = "";

$unit_options = ['Ampules', 'tablets', 'strip', 'bottle', 'Pack', 'capsules'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $unit_name = $_POST['unit_name'] ?? '';
    if ($unit_name && in_array($unit_name, $unit_options)) {
        $stmt = $conn->prepare("SELECT unit_id FROM units WHERE unit_name = ?");
        $stmt->bind_param("s", $unit_name);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows > 0) {
            $error_msg = "Unit already exists.";
        } else {
            $insertStmt = $conn->prepare("INSERT INTO units (unit_name) VALUES (?)");
            $insertStmt->bind_param("s", $unit_name);
            if ($insertStmt->execute()) {
                $success_msg = "Unit added successfully.";
            } else {
                $error_msg = "Failed to add unit.";
            }
            $insertStmt->close();
        }
        $stmt->close();
    } else {
        $error_msg = "Please select a valid unit.";
    }
}

if (isset($_GET['delete'])) {
    $del_id = intval($_GET['delete']);
    $delStmt = $conn->prepare("DELETE FROM units WHERE unit_id = ?");
    $delStmt->bind_param("i", $del_id);
    if ($delStmt->execute()) {
        $success_msg = "Unit deleted successfully.";
    } else {
        $error_msg = "Failed to delete unit.";
    }
    $delStmt->close();
}

$units = $conn->query("SELECT unit_id, unit_name FROM units ORDER BY unit_name");

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Units Management - Adwenpa Pharma</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <style>
        body {
            background-color: #e9f7f7;
            font-family: 'Poppins', sans-serif;
            padding: 2rem;
        }
        .container {
            max-width: 600px;
            background: #fff;
            padding: 2rem 3rem;
            border-radius: 12px;
            box-shadow: 0 8px 24px rgba(0,0,0,0.15);
            margin: auto;
        }
        h2 {
            color: #17a2b8;
            font-weight: 700;
            margin-bottom: 1.5rem;
            text-align: center;
        }
        .form-label {
            font-weight: 600;
            color: #33475b;
        }
        .btn-primary {
            background-color: #17a2b8;
            border-color: #17a2b8;
            font-weight: 700;
            transition: background-color 0.3s ease;
            border-radius: 6px;
        }
        .btn-primary:hover {
            background-color: #138496;
            border-color: #117a8b;
        }
        .alert {
            font-weight: 600;
            border-radius: 8px;
            margin-bottom: 1rem;
        }
        table {
            margin-top: 2rem;
        }
        thead th {
            background-color: #17a2b8;
            color: white;
            font-weight: 600;
            border-radius: 8px 8px 0 0;
            padding: 12px;
            text-align: center;
        }
        tbody td {
            text-align: center;
            padding: 12px;
            border-bottom: 1px solid #dee2e6;
        }
        a.btn-danger {
            padding: 4px 10px;
            font-size: 0.9rem;
            border-radius: 6px;
        }
    </style>
</head>
<body>
<div class="container">
    <h2>Manage Units</h2>

    <?php if ($success_msg): ?>
        <div class="alert alert-success"><?= htmlspecialchars($success_msg) ?></div>
    <?php elseif ($error_msg): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($error_msg) ?></div>
    <?php endif; ?>

    <form method="post" class="mb-4" autocomplete="off" novalidate>
        <div class="mb-3">
            <label for="unit_name" class="form-label">Select Unit</label>
            <select id="unit_name" name="unit_name" class="form-select" required>
                <option value="" disabled selected>-- Choose a Unit --</option>
                <?php foreach ($unit_options as $unit): ?>
                    <option value="<?= htmlspecialchars($unit) ?>"><?= htmlspecialchars($unit) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <button type="submit" class="btn btn-primary w-100">Add Unit</button>
    </form>

    <table class="table table-striped table-bordered rounded shadow-sm">
        <thead>
            <tr>
                <th>Unit Name</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($unit = $units->fetch_assoc()): ?>
                <tr>
                    <td><?= htmlspecialchars($unit['unit_name']) ?></td>
                    <td>
                        <a href="?delete=<?= $unit['unit_id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this unit?');">Delete</a>
                    </td>
                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
