<?php
require_once "../config/config.php";
session_start();
require_once "../includes/role_helpers.php";
requireLogin();

$sale_id = isset($_GET['sale_id']) ? intval($_GET['sale_id']) : 0;
if ($sale_id <= 0) {
    header("Location: pos.php");
    exit;
}

$conn = getDbConnection();

// Get sale info
$stmt = $conn->prepare("SELECT sale_date, total_amount, sales_rep_id FROM sales WHERE sale_id = ?");
$stmt->bind_param("i", $sale_id);
$stmt->execute();
$stmt->bind_result($sale_date, $total_amount, $sales_rep_id);
if (!$stmt->fetch()) {
    $stmt->close();
    $conn->close();
    die("Sale record not found.");
}
$stmt->close();

// Get sales rep username
$stmt = $conn->prepare("SELECT username FROM users WHERE user_id = ?");
$stmt->bind_param("i", $sales_rep_id);
$stmt->execute();
$stmt->bind_result($sales_rep_username);
$stmt->fetch();
$stmt->close();

// Get sale items with product details
$stmt = $conn->prepare("
    SELECT si.product_id, p.product_name, si.quantity, si.unit_price, (si.quantity * si.unit_price) AS subtotal
    FROM sale_items si
    JOIN products p ON si.product_id = p.product_id
    WHERE si.sale_id = ?
");
$stmt->bind_param("i", $sale_id);
$stmt->execute();
$result = $stmt->get_result();
$sale_items = $result->fetch_all(MYSQLI_ASSOC);
$stmt->close();

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Sale Details - Adwenpa Pharma</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <style>
        body { padding: 2rem; background: #f8f9fa; }
        .container { max-width: 720px; margin: auto; background: white; padding: 2rem; border-radius: 12px; box-shadow: 0 4px 20px rgba(13, 110, 253, 0.1); }
        @media print {
            body * { visibility: hidden; }
            #print-area, #print-area * { visibility: visible; }
            #print-area { position: absolute; left: 0; top: 0; width: 100%; }
            #print-button { display: none; }
        }
    </style>
</head>
<body>
<div class="container" id="print-area">
    <h1>Sale Details</h1>
    <p><strong>Sale ID:</strong> <?= htmlspecialchars($sale_id) ?></p>
    <p><strong>Sale Date:</strong> <?= htmlspecialchars($sale_date) ?></p>
    <p><strong>Sales Representative:</strong> <?= htmlspecialchars($sales_rep_username ?? 'Unknown') ?></p>

    <h3 class="mt-4">Items Sold</h3>
    <?php if (empty($sale_items)): ?>
        <p>No items found for this sale.</p>
    <?php else: ?>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Product Name</th>
                    <th class="text-center">Quantity</th>
                    <th class="text-end">Unit Price (₵)</th>
                    <th class="text-end">Subtotal (₵)</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($sale_items as $item): ?>
                    <tr>
                        <td><?= htmlspecialchars($item['product_name']) ?></td>
                        <td class="text-center"><?= htmlspecialchars($item['quantity']) ?></td>
                        <td class="text-end"><?= number_format($item['unit_price'], 2) ?></td>
                        <td class="text-end"><?= number_format($item['subtotal'], 2) ?></td>
                    </tr>
                <?php endforeach; ?>
                <tr class="fw-bold">
                    <td colspan="3" class="text-end">Total Amount</td>
                    <td class="text-end">₵<?= number_format($total_amount, 2) ?></td>
                </tr>
            </tbody>
        </table>
    <?php endif; ?>
</div>

<div class="container text-center mt-3">
    <button id="print-button" onclick="window.print()" class="btn btn-primary">Print Receipt</button>
    <a href="pos.php" class="btn btn-secondary ms-2">New Sale</a>
    <a href="dashboard.php" class="btn btn-secondary ms-2">Back to Dashboard</a>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
